<?php
if ( ! function_exists( 'blank_setup' ) ) :
	/**
	 * Sets up theme defaults and registers the various WordPress features that
	 * this theme supports.
	 */
	function blank_setup() {
		load_theme_textdomain( 'intentionally-blank' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );

		// This theme allows users to set a custom background.
		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'f5f5f5',
			)
		);

		add_theme_support( 'custom-logo' );
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 256,
				'width'       => 256,
				'flex-height' => true,
				'flex-width'  => true,
				'header-text' => array( 'site-title', 'site-description' ),
			)
		);
	}
endif; // end function_exists blank_setup.

add_action( 'after_setup_theme', 'blank_setup' );

remove_action( 'wp_head', '_custom_logo_header_styles' );

if ( ! is_admin() ) {
	add_action(
		'wp_enqueue_scripts',
		function() {
			wp_dequeue_style( 'global-styles' );
			wp_dequeue_style( 'classic-theme-styles' );
			wp_dequeue_style( 'wp-block-library' );
		}
	);
}
/**
 * Sets up theme defaults and registers the various WordPress features that
 * this theme supports.

 * @param class $wp_customize Customizer object.
 */
function blank_customize_register( $wp_customize ) {
	$wp_customize->remove_section( 'static_front_page' );

	$wp_customize->add_section(
		'blank_footer',
		array(
			'title'      => __( 'Footer', 'intentionally-blank' ),
			'priority'   => 120,
			'capability' => 'edit_theme_options',
			'panel'      => '',
		)
	);
	$wp_customize->add_setting(
		'blank_copyright',
		array(
			'type'              => 'theme_mod',
			'default'           => __( 'Intentionally Blank - Proudly powered by WordPress', 'intentionally-blank' ),
			'sanitize_callback' => 'wp_kses_post',
		)
	);

	/**
	 * Checkbox sanitization function

	 * @param bool $checked Whether the checkbox is checked.
	 * @return bool Whether the checkbox is checked.
	 */
	function blank_sanitize_checkbox( $checked ) {
		// Returns true if checkbox is checked.
		return ( ( isset( $checked ) && true === $checked ) ? true : false );
	}
	$wp_customize->add_setting(
		'blank_show_copyright',
		array(
			'default'           => true,
			'sanitize_callback' => 'blank_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'blank_copyright',
		array(
			'type'     => 'textarea',
			'label'    => __( 'Copyright Text', 'intentionally-blank' ),
			'section'  => 'blank_footer',
			'settings' => 'blank_copyright',
			'priority' => '10',
		)
	);
	$wp_customize->add_control(
		'blank_footer_copyright_hide',
		array(
			'type'     => 'checkbox',
			'label'    => __( 'Show footer with copyright Text', 'intentionally-blank' ),
			'section'  => 'blank_footer',
			'settings' => 'blank_show_copyright',
			'priority' => '20',
		)
	);
}
add_action( 'customize_register', 'blank_customize_register', 100 );

/**
 * ACF SVG filter to allow raw SVG code.
 * 
 * https://www.advancedcustomfields.com/resources/html-escaping/
 * 
 */
add_filter( 'wp_kses_allowed_html', 'acf_add_allowed_svg_tag', 10, 2 );

function acf_add_allowed_svg_tag( $tags, $context ) {
    if ( $context === 'acf' ) {
        $tags['svg']  = array(
            'xmlns'				=> true,
			'width'			=> true,
			'height'		=> true,
			'preserveAspectRatio'	=> true,
            'fill'				=> true,
            'viewbox'				=> true,
            'role'				=> true,
            'aria-hidden'			=> true,
            'focusable'				=> true,
        );
        $tags['path'] = array(
            'd'    => true,
            'fill' => true,
        );
    }

    return $tags;
    
    
}

/**
 * Переменная %%brand1%% для Yoast (берём ACF brand1).
 */
add_action('init', function () {
    if ( function_exists('wpseo_register_var_replacement') ) {
        wpseo_register_var_replacement(
            '%%brand1%%',
            function () {
                $val = '';

                // Если это одиночная запись — пробуем взять у неё
                if ( is_singular() ) {
                    $val = get_field('brand1', get_the_ID());
                }

                // Если пусто — пробуем из Options
                if ( ! $val ) {
                    $val = get_field('brand1', 'option');
                }

                // Если таксономия — пробуем у термина
                if ( ! $val && ( is_tax() || is_category() || is_tag() ) ) {
                    $term = get_queried_object();
                    if ( $term && ! is_wp_error( $term ) ) {
                        $val = get_field('brand1', 'term_' . $term->term_id);
                    }
                }

                return is_string($val) ? $val : '';
            },
            'advanced',
            'ACF поле brand1'
        );
    }
});

add_action('init', function () {
    if ( function_exists('wpseo_register_var_replacement') ) {
        wpseo_register_var_replacement(
            '%%brand2%%',
            function () {
                $val = '';

                // Если это одиночная запись — пробуем взять у неё
                if ( is_singular() ) {
                    $val = get_field('brand2', get_the_ID());
                }

                // Если пусто — пробуем из Options
                if ( ! $val ) {
                    $val = get_field('brand2', 'option');
                }

                // Если таксономия — пробуем у термина
                if ( ! $val && ( is_tax() || is_category() || is_tag() ) ) {
                    $term = get_queried_object();
                    if ( $term && ! is_wp_error( $term ) ) {
                        $val = get_field('brand2', 'term_' . $term->term_id);
                    }
                }

                return is_string($val) ? $val : '';
            },
            'advanced',
            'ACF поле brand2'
        );
    }
});

