<?php
/*
 * Template name: Страница Поддержка
 */
?>

<?php get_header(); ?>

<section class="set">
<div class="container">
	<h1 class="title-set"><?php the_field( 'zagolovok_supp-1' ); ?></h1>
	<p class="set-txt"><?php the_field( 'tekst_pod_zagolovkom_supp-1' ); ?></p>
	<a href="<?php the_field( 'ssylka_na_knopkah', 'option' ); ?>" class="set-button scroll-fade-in">Подключить через Telegram</a>
	</div>
</section>

<section class="support-diagnostic">
            <div class="container">
                <div class="diagnostic-card">
                    <h2><?php the_field( 'zagolovok_bloka_diagn' ); ?></h2>
                    <p><?php the_field( 'tekst_pod_zagolovkom_diagn' ); ?></p>
                    <div class="diagnostic-buttons">
                        <button class="support-btn" data-problem="connection">Не подключается</button>
                        <button class="support-btn" data-problem="speed">Медленно работает</button>
                        <button class="support-btn" data-problem="blocked">Сайты заблокированы</button>
                        <button class="support-btn" data-problem="other">Другая проблема</button>
                    </div>
                </div>
            </div>
        </section>

        <section class="support-solutions">
            <div class="container">
                <div class="solutions-grid">
                    <div class="solution-card" id="solution-connection" style="display: none;">
                        <h3>Проблемы с подключением</h3>
                        <div class="solution-steps">
							<?php if ( have_rows( 'problemy_s_podklyucheniem_diag' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag' ) ) : the_row(); ?>
                            <div class="step">
                                <div class="step-number"><?php the_sub_field( 'nomer_shaga_diagn' ); ?></div>
                                <div class="step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="solution-card" id="solution-speed" style="display: none;">
                        <h3>Медленная скорость</h3>
                        <div class="solution-steps">
							<?php if ( have_rows( 'problemy_s_podklyucheniem_diag_1' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_1' ) ) : the_row(); ?>
                            <div class="step">
                                <div class="step-number"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="solution-card" id="solution-blocked" style="display: none;">
                        <h3>Сайты остаются заблокированными</h3>
                        <div class="solution-steps">
                            <?php if ( have_rows( 'problemy_s_podklyucheniem_diag_2' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_2' ) ) : the_row(); ?>
                            <div class="step">
                                <div class="step-number"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="solution-card" id="solution-other" style="display: none;">
                        <h3>Другие проблемы</h3>
                        <div class="solution-steps">
                            <?php if ( have_rows( 'problemy_s_podklyucheniem_diag_3' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_3' ) ) : the_row(); ?>
                            <div class="step">
                                <div class="step-number"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

<section class="faq">
<div class="container">
	<h2 class="title-h2">Частые вопросы</h2>
	<div class="faq-block">
<?php if ( have_rows( 'vopros-otvet' ) ) : ?>
	<?php while ( have_rows( 'vopros-otvet' ) ) : the_row(); ?>			
<details class="details" name="faq">
  <summary class="details__title"><?php the_sub_field( 'vopros' ); ?></summary>
  <div class="details__content">
    <p><?php the_sub_field( 'otvet' ); ?></p>
  </div>
</details>
	<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>			
	</div>
	</div>
</section>

<script>
    // Global state
let currentPlatform = "windows";
let detectedOS = null;

// DOM Ready
document.addEventListener("DOMContentLoaded", function () {
  initializeApp();
});


    function initializeApp() {
  document.querySelectorAll(".support-btn").forEach((btn) => {
    btn.addEventListener("click", function () {
      const problem = this.dataset.problem;
      showSolution(problem);

      // Update active state
      document
        .querySelectorAll(".support-btn")
        .forEach((b) => b.classList.remove("active"));
      this.classList.add("active");
    });
  });
}

function showSolution(problem) {
  // Hide all solutions
  document.querySelectorAll(".solution-card").forEach((card) => {
    card.style.display = "none";
  });

  // Show selected solution
  const solutionCard = document.getElementById(`solution-${problem}`);
  if (solutionCard) {
    solutionCard.style.display = "block";
    solutionCard.scrollIntoView({ behavior: "smooth", block: "center" });
  }
}
</script>

<?php get_footer(); ?>