<?php get_header(); ?>

<section class="intro">
<div class="container">
	<div class="intro-block">
		<h1 class="title-h1 scroll-fade-in"><?php the_field( 'zagolovok_home' ); ?></h1>
		<p class="txt scroll-fade-in"><?php the_field( 'tekst_pod_zagolovkom_home' ); ?></p>
		<div class="intro-button scroll-fade-in">
			<a href="<?php the_field( 'ssylka_na_knopkah', 'option' ); ?>" class="intro-button-b">Получить ключ</a>
			<a href="#features" class="intro-button-c">Узнать больше</a>
		</div>
		<div class="intro-card scroll-fade-in">
			<?php if ( have_rows( 'preimushhestva_home' ) ) : ?>
	<?php while ( have_rows( 'preimushhestva_home' ) ) : the_row(); ?>
			<div class="card-item">
				<span class="intro-numb"><?php the_sub_field( 'tekst_v_pervoj_stroke' ); ?></span>
				<span class="intro-txt"><?php the_sub_field( 'tekst_vo_vtoroj_stroke' ); ?></span>
			</div>
			<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
		</div>
	</div>
	</div>
</section>

<section id="features" class="why">
<div class="container">
	<h2 class="title-h2"><?php the_field( 'zagolovok_bloka_pochemu_vybirayut' ); ?></h2>
	<div class="why-block">
		<?php if ( have_rows( 'kartochki_bloka_home' ) ) : ?>
	<?php while ( have_rows( 'kartochki_bloka_home' ) ) : the_row(); ?>
		<div class="why-item">
			<div class="why-icon">
				<?php the_sub_field( 'kod_ikonki_svg' ); ?>
			</div>
			<h3><?php the_sub_field( 'zagolovok_card_home' ); ?></h3>
			<p><?php the_sub_field( 'tekst_card_home' ); ?></p>
		</div>
		<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
	</div>
	</div>
</section>

<section class="now">
<div class="container">
	<h2 class="title-h2-s">Протестируйте <?php the_field('brand1', 'option'); ?> в течение 7 дней</h2>
	<p class="now-txt">Присоединяйтесь к миллионам пользователей, которые уже защищают свой интернет</p>
	<a href="<?php the_field( 'ssylka_na_knopkah', 'option' ); ?>" class="button-now">Получить ключ</a>
	</div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {

  let blocks = document.querySelectorAll('.why-item');



  function checkBlocksVisibility() {

    let windowHeight = window.innerHeight;



    blocks.forEach(block => {

      let blockPosition = block.getBoundingClientRect().top;



      if (blockPosition < windowHeight - 100) {

        block.style.opacity = "1";

        block.style.transform = "translateY(0)";

      } else {

        block.style.opacity = "0";

        block.style.transform = "translateY(50px)";

      }

    });

  }



  checkBlocksVisibility();



  window.addEventListener('scroll', checkBlocksVisibility);

});
</script>

<?php get_footer(); ?>